/*
 * Decompiled with CFR 0.152.
 */
package net.noip.codebox.dirview;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.TransformerException;
import net.noip.codebox.dirview.DirBean;
import net.noip.codebox.dirview.Utils;
import org.jdom.Document;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class DirView {
    private static Options opts;
    private static final String OPT_DUMPXML = "-x";
    private static final String OPT_SILENT = "-s";
    private static final String OPT_SHOWHELP = "-?";
    private static final String USAGE = "Usage: java -jar dirview.jar [-x] [-s] [-?] <directory> [<xsl name>] [<report name>]\n  -x Dump the XML used to generate the report\n  -s Don't show progress information\n  -? Display this help information\n";

    public static void main(String[] args) {
        try {
            opts = DirView.processArgs(args);
            if (DirView.opts.showHelp) {
                System.out.println(USAGE);
            } else if (DirView.opts.errors.size() > 0) {
                for (String error : DirView.opts.errors) {
                    System.err.println(error);
                }
            } else {
                Utils.isVerbose = DirView.opts.isVerbose;
                DirBean bean = new DirBean(DirView.opts.dir);
                Document doc = DirView.makeDocFromDirBean(bean);
                if (DirView.opts.dumpXml) {
                    new XMLOutputter(Format.getPrettyFormat()).output(doc, (OutputStream)new FileOutputStream(DirView.opts.xmlFile, false));
                    Utils.printMsg("XML data written to " + DirView.opts.xmlFile);
                }
                Utils.printMsg("Transforming data with " + DirView.opts.xslFile);
                Utils.transformXml(new XMLOutputter().outputString(doc), new File(DirView.opts.reportName), new FileInputStream(DirView.opts.xslFile));
                Utils.printMsg("Finished.");
            }
        }
        catch (IOException ex) {
            Utils.printErr(ex.getMessage());
        }
        catch (TransformerException e) {
            Utils.printErr("Unable to perform the requested XSL transformation, there is probably a bug in the XSL file.", e);
        }
    }

    private static Document makeDocFromDirBean(DirBean bean) {
        Document doc = new Document();
        doc.setRootElement(bean.toElement());
        return doc;
    }

    private static Options processArgs(String[] args) {
        Options options = new Options();
        boolean processedDirArgument = false;
        boolean processedReportArgument = false;
        boolean processedXslArgument = false;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (OPT_DUMPXML.equalsIgnoreCase(arg)) {
                options.dumpXml = true;
            } else if (OPT_SILENT.equalsIgnoreCase(arg)) {
                options.isVerbose = false;
            } else if (OPT_SHOWHELP.equalsIgnoreCase(arg)) {
                options.showHelp = true;
            } else if (!processedDirArgument) {
                File file = new File(arg);
                if (!file.exists()) {
                    options.errors.add("Specified directory could not be found: " + arg);
                } else if (!file.isDirectory()) {
                    options.errors.add("Specified path is not a directory: " + arg);
                } else {
                    options.dir = file;
                }
                processedDirArgument = true;
            } else if (!processedXslArgument) {
                String xslFileName = "xsl/" + arg + ".xsl";
                File file = new File(xslFileName);
                if (!file.exists()) {
                    options.errors.add("Unable to locate the file " + xslFileName);
                } else {
                    options.xslFile = xslFileName;
                }
                processedXslArgument = true;
            } else if (!processedReportArgument) {
                options.reportName = arg;
                processedReportArgument = true;
            } else {
                options.errors.add("Unrecognised command-line argument: " + arg);
            }
            ++n2;
        }
        if (!processedDirArgument) {
            options.errors.add(USAGE);
        }
        return options;
    }

    private static class Options {
        private static final String DEFAULT_XSL_NAME = "xsl/plaintable.xsl";
        private static final String DEFAULT_REPORT_NAME = "report.html";
        private static final String XML_DUMP_FILE = "report.xml";
        boolean dumpXml = false;
        boolean isVerbose = true;
        boolean showHelp = false;
        String reportName = "report.html";
        String xslFile = "xsl/plaintable.xsl";
        String xmlFile = "report.xml";
        File dir;
        List<String> errors = new ArrayList<String>();

        private Options() {
        }
    }
}

