/*
 * Decompiled with CFR 0.152.
 */
package net.noip.codebox.dirview;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.StringReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class Utils {
    public static boolean isVerbose = false;

    public static void printMsg(String msg) {
        if (isVerbose) {
            System.out.println(msg);
        }
    }

    public static void printErr(String msg, Throwable ex) {
        Utils.printErr(String.valueOf(msg) + " [" + ex.toString() + "]");
    }

    public static void printErr(String msg) {
        System.err.println("ERROR: " + msg);
    }

    public static void transformXml(String xml, File htmlFile, InputStream xslInputStream) throws FileNotFoundException, TransformerException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer(new StreamSource(xslInputStream));
        transformer.transform(new StreamSource(new StringReader(xml)), new StreamResult(new FileOutputStream(htmlFile)));
    }

    public static String formatForJson(String fileName) {
        return fileName.replaceAll("'", "\\\\'");
    }
}

