<?xml version="1.0"?>
<xsl:transform xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
    <xsl:template match="/">
		<html>
			<head>
				<title>DirView Report</title>
				<style>
				    body{
				        font-family: monospace;
				    }
				    h1{
				    	font-size: 1.2em;
				    	text-align: center;
				    }
				    h2{
				    	font-size: 1em;
				    }
				    small{
				    	font-size: 0.9em;
				    }
				    th{
				    	border: 1px solid gray; 
				    	background-color: yellow; 
				    	cursor: pointer;
				    	font-weight: normal;
				    	text-align: left;
				    }
				    td{
				    	border: 1px solid gray;
				    }
				</style>
				<script>
				var DATA={'dirs' : [
				<xsl:for-each select="//dir">
					<xsl:if test="child::file">
						{'name' : '<xsl:value-of select="@jsonSafePath" />', 'files' : [
						<xsl:for-each select="file">
							{
							'name' : '<xsl:value-of select="@jsonSafeName"/>',
							'size' :  <xsl:value-of select="@size"/>,
							'sizeDisplay' :  '<xsl:value-of select="@formattedSize"/>',
							'date' : '<xsl:value-of select="@formattedModTime"/>'
							}
							<xsl:if test="position()!=last()">,</xsl:if>
						</xsl:for-each>
						]}
						<xsl:if test="position()!=last()">,</xsl:if>
					</xsl:if>
   				</xsl:for-each>
   				]};
   				
   				var SORT_FUNCTIONS = {
   					'name' : function(f1, f2){
   						if (f1.name &#x003e; f2.name){
   							return 1;
   						} else if (f1.name &#x003c; f2.name){
   							return -1;
   						} else {
   							return 0;
   						}
   					},
   					'size' : function(f1, f2){
						return f1.size - f2.size;
   					},
   					'date' : function(f1, f2){
   						if (f1.date &#x003e; f2.date){
   							return 1;
   						} else if (f1.date &#x003c; f2.date){
   							return -1;
   						} else {
   							return 0;
   						}
   					}
   					
   				};
   				
   				function doList(fnSort){
   					var thisDir;
   					for (var i=0; i&#x003c;DATA.dirs.length; i++){
   						thisDir = DATA.dirs[i];
   						drawTable(thisDir, fnSort, i);
   					}
   				}
   				
   				function drawTable(thisDir, fnSort, i){
					if (fnSort) thisDir.files.sort(fnSort);
					var tableName = 'table' + i;
   					var table = document.getElementById(tableName);
   					var mainDiv = document.getElementById('main');
   					
   					if (table){ 
   						removeAllChildren(table);
   					} else {
   						addChild(mainDiv, 'h2', {}, thisDir.name );
   						table = addChild(mainDiv, 'table', {'id' : tableName});
   					}
   					
   					var thead  = addChild(table, 'thead');
   					
   					var row = addChild(thead, 'tr');
   					var colHeader;
   					colHeader = addChild(row, 'th', {}, 'Name');
   					addEventHandler(colHeader, 'onclick', function(e){
   						drawTable(thisDir, SORT_FUNCTIONS.name, i);
   					});
   					
   					colHeader = addChild(row, 'th', {}, 'Size');
   					addEventHandler(colHeader, 'onclick', function(e){
   						drawTable(thisDir, SORT_FUNCTIONS.size, i);
   					});
   					
   					colHeader = addChild(row, 'th', {}, 'Date');
   					addEventHandler(colHeader, 'onclick', function(e){
   						drawTable(thisDir, SORT_FUNCTIONS.date, i);
   					});

   					var tbody = addChild(table, 'tbody');
   					
					for (var j=0; j&#x003c;thisDir.files.length; j++){
						thisFile = thisDir.files[j];
						addTableRow(tbody, thisFile); 
					}
   				}
   				
   				function addTableRow(domTable, thisFile){
   					var row = addChild(domTable, 'tr');
   					addChild(row, 'td', {}, thisFile.name);
   					addChild(row, 'td', {}, thisFile.sizeDisplay);
   					addChild(row, 'td', {}, thisFile.date);
   					return row;
   				}
   				
   				function addChild(parentElement, elementType, attributes, text){
					if (typeof parentElement == 'string'){
					 // if 'parent' is a string then assume it's the id of the element we need
						parentElement = document.getElementById(parentElement);
					}
					var newElement = document.createElement(elementType);
					
					foreach(attributes, function(name, value){
						if (name == 'style'){
							newElement.style.cssText = value;
						} else {
							newElement.setAttribute(name, value);
						}
						
					});
					
					if (text){
						var textNode = document.createTextNode(text);
						newElement.appendChild(textNode);
					}
				
					parentElement.appendChild(newElement);
					
					return newElement;
				}
				function removeAllChildren(element){
					if (typeof element == 'string'){
					 // if 'element' is a string then assume it's the id of the element we need
						element = document.getElementById(element);	
					}
				
					var childNode;
					while (childNode=element.childNodes[0]) {
						element.removeChild(childNode);
					}
				}
				function addEventHandler( element, eventName, handler ){
					if (typeof element == 'string'){
					 // if 'element' is a string then assume it's the id of the element we need
						element = document.getElementById(element);	
					} 
				
					if (eventName.substring(0,2)==='on'){
					 // if the eventName parameter starts with the characters 'on' then remove them
						eventName = eventName.substring(2);
					}
				
					if (element.attachEvent){
					 // IE only
					 	element.attachEvent('on' + eventName, handler)
					
					} else {
					 // Non-IE browsers
					 	element.addEventListener(eventName, handler, false);
					}
					
				}
				function foreach(obj, fnDoThis){
					if (obj &#x0026;&#x0026; fnDoThis){
						for(var prop in obj){
							if (obj.hasOwnProperty(prop)){
								if (fnDoThis(prop, obj[prop])){
									break;
								}
							}
						}
					}
				}
				</script>
			</head>
			<body onload="doList(SORT_FUNCTIONS.name)">
			    <h1>DirView Report for <xsl:value-of select="/dir/@path"/></h1>		
			    <small>Click the column headings to sort the data.</small>
			    <div id="main"></div>
			    <br/>
			    <small>This report was generated by <a href="http://codebox.no-ip.net/controller?page=dirview">DirView</a></small>		
			</body>
		</html>
    </xsl:template>
</xsl:transform>