/*
 * Decompiled with CFR 0.152.
 */
package net.noip.codebox.httpbuilder;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.noip.codebox.httpbuilder.AboutDialog;
import net.noip.codebox.httpbuilder.HttpController;
import net.noip.codebox.httpbuilder.HttpModel;
import net.noip.codebox.httpbuilder.HttpRequest;
import net.noip.codebox.httpbuilder.HttpUrl;
import net.noip.codebox.httpbuilder.ProxyConfig;
import net.noip.codebox.httpbuilder.ProxySettings;
import net.noip.codebox.httpbuilder.RequestHeader;
import net.noip.codebox.httpbuilder.headerhelpers.AddCustomHeaderDialog;
import net.noip.codebox.httpbuilder.headerhelpers.HeaderHelperBase;
import net.noip.codebox.httpbuilder.util.Config;
import net.noip.codebox.httpbuilder.util.ConfigException;
import net.noip.codebox.httpbuilder.util.Utils;
import org.jdesktop.layout.GroupLayout;

public class HttpView
extends JFrame
implements Observer {
    private HttpModel model;
    private HttpController controller;
    private GuiState guiState;
    private DefaultListModel headerListModel;
    private List<HttpRequest> requests;
    private boolean gotNewReplyData = false;
    private final int MAX_REQS;
    private JButton btnAddCustomHeader;
    private JButton btnAddHeader;
    private JButton btnRemoveHeader;
    private JButton btnSend;
    private JButton btnShowHeaderHelper;
    private JButton btnUpdateHeader;
    private ButtonGroup btngrpHttp;
    private ButtonGroup btngrpMethod;
    private JComboBox cmbHeaders;
    private JComboBox cmbMethods;
    private JComboBox cmbUrl;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JPanel jPanel2;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JLabel lblStatus;
    private JList lstHeaders;
    private JMenu mnuEdit;
    private JMenu mnuFile;
    private JMenu mnuHelp;
    private JMenuBar mnubarMain;
    private JMenuItem mnuitemAbout;
    private JMenuItem mnuitemClearHistory;
    private JMenuItem mnuitemExit;
    private JMenuItem mnuitemProxy;
    private JRadioButton rdbHttp10;
    private JRadioButton rdbHttp11;
    private JTextField txtHeaderValue;
    private JTextArea txtResponse;

    private synchronized GuiState getGuiState() {
        return this.guiState;
    }

    private void setStatus(final String statusText) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                HttpView.this.lblStatus.setText(statusText);
            }
        });
    }

    private synchronized void setGuiState(GuiState guiState) {
        this.guiState = guiState;
        final boolean isIdle = GuiState.IDLE.equals((Object)guiState);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (isIdle) {
                    HttpView.this.btnSend.setText("Send");
                } else {
                    HttpView.this.btnSend.setText("Cancel");
                }
                HttpView.this.cmbUrl.setEnabled(isIdle);
                HttpView.this.lstHeaders.setEnabled(isIdle);
                HttpView.this.cmbHeaders.setEnabled(isIdle);
                HttpView.this.cmbMethods.setEnabled(isIdle);
                HttpView.this.btnAddHeader.setEnabled(isIdle);
                HttpView.this.btnRemoveHeader.setEnabled(isIdle);
                HttpView.this.btnUpdateHeader.setEnabled(isIdle);
                HttpView.this.btnShowHeaderHelper.setEnabled(isIdle);
                HttpView.this.btnAddCustomHeader.setEnabled(isIdle);
                HttpView.this.txtHeaderValue.setEnabled(isIdle);
                HttpView.this.txtResponse.setEnabled(isIdle);
                HttpView.this.rdbHttp10.setEnabled(isIdle);
                HttpView.this.rdbHttp11.setEnabled(isIdle);
                HttpView.this.mnuFile.setEnabled(isIdle);
                HttpView.this.mnuEdit.setEnabled(isIdle);
                HttpView.this.mnuHelp.setEnabled(isIdle);
                if (!isIdle && !HttpView.this.gotNewReplyData) {
                    HttpView.this.txtResponse.setText("");
                }
            }
        });
    }

    private void updateGuiWithCurrentRequest(final HttpRequest request) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (request != null) {
                    HttpView.this.cmbMethods.setSelectedItem((Object)request.getMethod());
                    HttpView.this.rdbHttp10.setSelected(HttpRequest.HttpVersion.V1_0.equals((Object)request.getHttpVersion()));
                    HttpView.this.rdbHttp11.setSelected(HttpRequest.HttpVersion.V1_1.equals((Object)request.getHttpVersion()));
                    HttpView.this.headerListModel.removeAllElements();
                    for (HttpRequest.HeaderValue header : request.getHeaders()) {
                        HttpView.this.headerListModel.addElement(header);
                    }
                }
            }
        });
    }

    private void onSendOrCancelClick() {
        if (GuiState.REQUEST_PENDING.equals((Object)this.getGuiState())) {
            this.model.cancelPendingRequests();
        } else if (GuiState.IDLE.equals((Object)this.getGuiState())) {
            try {
                this.setGuiState(GuiState.REQUEST_PENDING);
                this.doSend();
            }
            catch (Exception ex) {
                Utils.showErrorMsg(ex.getMessage());
                this.setGuiState(GuiState.IDLE);
            }
        } else assert (false);
    }

    private void onClearHistoryClicked() {
        int answer = JOptionPane.showConfirmDialog(this, "Remove all URL and request history - are you sure?", "Are you sure?", 0);
        if (answer == 0) {
            Utils.clearRequests();
            this.txtResponse.setText("");
            try {
                this.loadListWithRequests();
            }
            catch (IOException e) {
                Utils.showErrorMsg(e.toString());
            }
        }
    }

    private void onHelpAbout() {
        AboutDialog aboutDialog = new AboutDialog("HttpBuilder", "0.2.1", "rob@codebox.no-ip.net", "http://codebox.no-ip.net/controller?page=httpbuilder", this);
    }

    private void onRequestListChange() {
        Object s = this.cmbUrl.getSelectedItem();
        if (s instanceof HttpRequest) {
            this.updateGuiWithCurrentRequest((HttpRequest)s);
        }
    }

    private void onHeaderListKeyRelease(KeyEvent evt) {
        int key = evt.getKeyCode();
        if (key == 127) {
            this.removeHeader();
        }
    }

    private void onAddCustomHeaderClick() {
        AddCustomHeaderDialog helperDialog = new AddCustomHeaderDialog();
        helperDialog.setValueHandler(new HeaderHelperBase.ValueHandler(){

            public void onValue(String value) {
                RequestHeader headerObject = new RequestHeader(value);
                int indexOfHeader = Utils.comboIndexOf(HttpView.this.cmbHeaders, headerObject);
                if (indexOfHeader < 0) {
                    HttpView.this.cmbHeaders.addItem(headerObject);
                    HttpView.this.cmbHeaders.setSelectedItem(headerObject);
                    try {
                        Config.addCustomHeader(value);
                    }
                    catch (ConfigException ex) {
                        Utils.showErrorMsg(ex.getMessage());
                    }
                } else {
                    HttpView.this.cmbHeaders.setSelectedIndex(indexOfHeader);
                }
                HttpView.this.onHeaderListChange();
            }
        });
        Utils.positionDialogInParent(helperDialog, this);
        helperDialog.setVisible(true);
    }

    private void doSend() throws IllegalArgumentException, IOException {
        this.gotNewReplyData = false;
        HttpRequest req = this.buildRequestFromGui();
        ProxyConfig proxyConfig = null;
        try {
            boolean useProxy = Config.getBooleanValue("proxy.useproxy");
            String proxyHost = Config.getStringValue("proxy.host");
            int proxyPort = Config.getIntValue("proxy.port");
            String proxyUser = Config.getStringValue("proxy.user");
            String proxyPass = Config.getStringValue("proxy.pass");
            proxyConfig = new ProxyConfig(useProxy, proxyHost, proxyPort, proxyUser, proxyPass);
        }
        catch (NumberFormatException e) {
            Utils.showErrorMsg(e.getMessage());
        }
        catch (ConfigException e) {
            Utils.showErrorMsg(e.getMessage());
        }
        if (proxyConfig == null) {
            proxyConfig = new ProxyConfig(false, "", 80, "", "");
        }
        this.controller.send(req, proxyConfig);
        if (this.requests.contains(req)) {
            if (this.requests.indexOf(req) != 0) {
                this.requests.remove(req);
                this.requests.add(0, req);
            }
        } else {
            this.requests.add(0, req);
            if (this.requests.size() > this.MAX_REQS) {
                this.requests.remove(this.requests.size() - 1);
            }
        }
        Utils.saveRequests(this.requests);
        this.loadListWithRequests();
    }

    private void loadListWithRequests() throws IOException {
        this.cmbUrl.removeAllItems();
        this.requests = Utils.loadRequests();
        int itemCount = this.requests.size();
        int i = 0;
        while (i < itemCount) {
            HttpRequest req = this.requests.get(i);
            this.cmbUrl.addItem(req);
            ++i;
        }
        if (this.requests.size() > 0) {
            this.cmbUrl.setSelectedIndex(0);
        }
    }

    public void update(Observable arg0, Object arg1) {
        if (arg1 instanceof HttpModel.NotificationType) {
            HttpModel.NotificationType notificationType = (HttpModel.NotificationType)((Object)arg1);
            if (notificationType == HttpModel.NotificationType.STATE_CHANGE) {
                HttpModel.HttpModelState state = this.model.getState();
                switch (state) {
                    case CONNECTED_PASSIVE: {
                        this.setStatus("Connected");
                        break;
                    }
                    case DISCONNECTED: {
                        this.setStatus("Disconnected");
                        break;
                    }
                    case RECEIVING: {
                        this.setStatus(this.formatReceivingMessage());
                        break;
                    }
                    case AWAITING_RESPONSE: {
                        this.setStatus("Waiting for response");
                        break;
                    }
                    case SENDING: {
                        this.setStatus("Sending");
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
            }
            if (notificationType == HttpModel.NotificationType.NEW_DATA) {
                this.gotNewReplyData = true;
                this.setGuiState(GuiState.IDLE);
                this.txtResponse.setText(this.model.getLatestResponse());
            }
        }
    }

    private String formatReceivingMessage() {
        int bytesReceived = this.model.getReceivedCount();
        String bytesReceivedMsg = bytesReceived < 1024 ? String.valueOf(bytesReceived) + " byte" + (bytesReceived == 1 ? "" : "s") : (bytesReceived < 0x100000 ? String.valueOf(bytesReceived / 1024) + " kB" : String.valueOf(bytesReceived / 0x100000) + " MB");
        return "Received " + bytesReceivedMsg;
    }

    private HttpRequest buildRequestFromGui() {
        HttpRequest.HttpVersion version;
        HttpRequest.Method method = HttpRequest.Method.valueOf(this.cmbMethods.getSelectedItem().toString());
        if (this.rdbHttp10.isSelected()) {
            version = HttpRequest.HttpVersion.V1_0;
        } else if (this.rdbHttp11.isSelected()) {
            version = HttpRequest.HttpVersion.V1_1;
        } else {
            throw new IllegalStateException("No http version selected");
        }
        HttpUrl httpUrl = new HttpUrl(this.cmbUrl.getSelectedItem().toString());
        int headerCount = this.lstHeaders.getModel().getSize();
        ArrayList<HttpRequest.HeaderValue> headerList = new ArrayList<HttpRequest.HeaderValue>();
        int i = 0;
        while (i < headerCount) {
            headerList.add((HttpRequest.HeaderValue)this.lstHeaders.getModel().getElementAt(i));
            ++i;
        }
        return new HttpRequest(method, httpUrl, version, headerList);
    }

    private void updateSelectedHeader() {
        HttpRequest.HeaderValue selectedHeader = (HttpRequest.HeaderValue)this.lstHeaders.getSelectedValue();
        if (selectedHeader != null) {
            this.cmbHeaders.setSelectedItem(selectedHeader.header);
            this.txtHeaderValue.setText(selectedHeader.value);
        }
    }

    private void addHeader() {
        HttpRequest.HeaderValue newHeader = new HttpRequest.HeaderValue();
        newHeader.header = (RequestHeader)this.cmbHeaders.getSelectedItem();
        newHeader.value = this.txtHeaderValue.getText();
        this.headerListModel.addElement(newHeader);
    }

    private void removeHeader() {
        HttpRequest.HeaderValue selectedHeader = (HttpRequest.HeaderValue)this.lstHeaders.getSelectedValue();
        if (selectedHeader != null) {
            int selIndex = this.lstHeaders.getSelectedIndex();
            this.headerListModel.removeElement(selectedHeader);
            this.txtHeaderValue.setText("");
            int listCount = this.lstHeaders.getModel().getSize();
            if (selIndex >= listCount) {
                selIndex = listCount - 1;
            }
            if (selIndex >= 0) {
                this.lstHeaders.setSelectedIndex(selIndex);
            }
        }
    }

    private void updateHeader() {
        HttpRequest.HeaderValue selectedHeader = (HttpRequest.HeaderValue)this.lstHeaders.getSelectedValue();
        if (selectedHeader != null) {
            HttpRequest.HeaderValue updatedHeader = new HttpRequest.HeaderValue();
            updatedHeader.header = (RequestHeader)this.cmbHeaders.getSelectedItem();
            updatedHeader.value = this.txtHeaderValue.getText();
            int selIndex = this.lstHeaders.getSelectedIndex();
            this.headerListModel.removeElementAt(selIndex);
            this.headerListModel.addElement(updatedHeader);
            this.lstHeaders.setModel(this.headerListModel);
            this.lstHeaders.setSelectedIndex(selIndex);
        }
    }

    private void populateMethodList() {
        this.cmbMethods.removeAllItems();
        HttpRequest.Method[] methodArray = HttpRequest.Method.values();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            HttpRequest.Method method = methodArray[n2];
            this.cmbMethods.addItem(method);
            ++n2;
        }
    }

    private void populateHeaderList() {
        this.cmbHeaders.removeAllItems();
        RequestHeader[] requestHeaderArray = RequestHeader.KNOWN_HEADERS;
        int n = RequestHeader.KNOWN_HEADERS.length;
        int n2 = 0;
        while (n2 < n) {
            RequestHeader header = requestHeaderArray[n2];
            this.cmbHeaders.addItem(header);
            ++n2;
        }
        try {
            List<String> customHeaderNames = Config.getCustomHeaders();
            for (String headerName : customHeaderNames) {
                this.cmbHeaders.addItem(new RequestHeader(headerName));
            }
        }
        catch (ConfigException ex) {
            Utils.showErrorMsg(ex.getMessage());
        }
    }

    private void onHeaderListChange() {
        RequestHeader header = (RequestHeader)this.cmbHeaders.getSelectedItem();
        if (header != null) {
            this.btnShowHeaderHelper.setEnabled(header.hasHelperDialog());
        }
    }

    private void onHeaderHelperButtonClick() {
        RequestHeader header = (RequestHeader)this.cmbHeaders.getSelectedItem();
        if (header != null) {
            try {
                HeaderHelperBase helperDialog = header.getHelperDialog();
                helperDialog.setValueHandler(new HeaderHelperBase.ValueHandler(){

                    public void onValue(String value) {
                        HttpView.this.txtHeaderValue.setText(value);
                    }
                });
                Utils.positionDialogInParent(helperDialog, this);
                helperDialog.setVisible(true);
            }
            catch (Exception e) {
                Utils.showErrorMsg(e.getMessage());
            }
        }
    }

    private void doExit() {
        try {
            Config.setIntValue("windows.main.width", this.getSize().width);
            Config.setIntValue("windows.main.height", this.getSize().height);
        }
        catch (ConfigException configException) {
            // empty catch block
        }
        System.exit(0);
    }

    public HttpView(HttpModel model, HttpController controller) throws NumberFormatException, ConfigException {
        this.model = model;
        model.addObserver(this);
        this.controller = controller;
        this.initComponents();
        this.populateMethodList();
        this.populateHeaderList();
        this.headerListModel = new DefaultListModel();
        this.lstHeaders.setModel(this.headerListModel);
        this.rdbHttp11.setSelected(true);
        this.setSize(Config.getIntValue("windows.main.width"), Config.getIntValue("windows.main.height"));
        this.setVisible(true);
        this.setTitle("Codebox Software - HttpBuilder");
        this.MAX_REQS = Config.getIntValue("windows.main.max_reqs");
        try {
            this.requests = Utils.loadRequests();
            this.loadListWithRequests();
            HttpRequest request = (HttpRequest)this.cmbUrl.getSelectedItem();
            this.updateGuiWithCurrentRequest(request);
        }
        catch (IOException e) {
            this.requests = new ArrayList<HttpRequest>();
        }
        this.setGuiState(GuiState.IDLE);
    }

    private void initComponents() {
        this.btngrpMethod = new ButtonGroup();
        this.btngrpHttp = new ButtonGroup();
        this.jPanel5 = new JPanel();
        this.jLabel5 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.txtResponse = new JTextArea();
        this.jPanel4 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.lstHeaders = new JList();
        this.jLabel6 = new JLabel();
        this.cmbHeaders = new JComboBox();
        this.txtHeaderValue = new JTextField();
        this.btnShowHeaderHelper = new JButton();
        this.btnAddHeader = new JButton();
        this.btnRemoveHeader = new JButton();
        this.btnUpdateHeader = new JButton();
        this.jLabel1 = new JLabel();
        this.btnSend = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel2 = new JLabel();
        this.cmbMethods = new JComboBox();
        this.jLabel3 = new JLabel();
        this.rdbHttp10 = new JRadioButton();
        this.rdbHttp11 = new JRadioButton();
        this.jLabel7 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel8 = new JLabel();
        this.cmbUrl = new JComboBox();
        this.btnAddCustomHeader = new JButton();
        this.lblStatus = new JLabel();
        this.mnubarMain = new JMenuBar();
        this.mnuFile = new JMenu();
        this.mnuitemExit = new JMenuItem();
        this.mnuEdit = new JMenu();
        this.mnuitemProxy = new JMenuItem();
        this.mnuitemClearHistory = new JMenuItem();
        this.mnuHelp = new JMenu();
        this.mnuitemAbout = new JMenuItem();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                HttpView.this.formWindowClosing(evt);
            }
        });
        this.jPanel5.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel5.setFont(new Font("Tahoma", 1, 11));
        this.jLabel5.setText("Response");
        this.jScrollPane2.setVerticalScrollBarPolicy(22);
        this.txtResponse.setColumns(20);
        this.txtResponse.setEditable(false);
        this.txtResponse.setRows(5);
        this.jScrollPane2.setViewportView(this.txtResponse);
        GroupLayout jPanel5Layout = new GroupLayout((Container)this.jPanel5);
        this.jPanel5.setLayout((LayoutManager)jPanel5Layout);
        jPanel5Layout.setHorizontalGroup((GroupLayout.Group)jPanel5Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel5Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel5Layout.createParallelGroup(1).add((Component)this.jScrollPane2, -1, 745, Short.MAX_VALUE).add((Component)this.jLabel5)).addContainerGap()));
        jPanel5Layout.setVerticalGroup((GroupLayout.Group)jPanel5Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel5Layout.createSequentialGroup().add((Component)this.jLabel5).addPreferredGap(0).add((Component)this.jScrollPane2, -1, 256, Short.MAX_VALUE).addContainerGap()));
        this.jPanel4.setBorder(BorderFactory.createEtchedBorder());
        this.lstHeaders.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                HttpView.this.lstHeadersKeyReleased(evt);
            }
        });
        this.lstHeaders.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                HttpView.this.lstHeadersValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.lstHeaders);
        this.jLabel6.setFont(new Font("Tahoma", 1, 11));
        this.jLabel6.setText("Request:");
        this.cmbHeaders.setFont(new Font("Tahoma", 0, 10));
        this.cmbHeaders.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cmbHeaders.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HttpView.this.cmbHeadersActionPerformed(evt);
            }
        });
        this.btnShowHeaderHelper.setText("jButton1");
        this.btnShowHeaderHelper.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HttpView.this.btnShowHeaderHelperActionPerformed(evt);
            }
        });
        this.btnAddHeader.setText("Add");
        this.btnAddHeader.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent evt) {
                HttpView.this.btnAddHeaderMouseReleased(evt);
            }
        });
        this.btnRemoveHeader.setText("Remove");
        this.btnRemoveHeader.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent evt) {
                HttpView.this.btnRemoveHeaderMouseReleased(evt);
            }
        });
        this.btnUpdateHeader.setText("Update");
        this.btnUpdateHeader.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent evt) {
                HttpView.this.btnUpdateHeaderMouseReleased(evt);
            }
        });
        this.jLabel1.setFont(new Font("Tahoma", 1, 11));
        this.jLabel1.setHorizontalAlignment(2);
        this.jLabel1.setText("URL:");
        this.btnSend.setText("Send");
        this.btnSend.setMargin(new Insets(2, 4, 2, 4));
        this.btnSend.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                HttpView.this.btnSendMouseClicked(evt);
            }
        });
        this.jLabel2.setFont(new Font("Tahoma", 1, 11));
        this.jLabel2.setText("Method:");
        this.jLabel2.setMaximumSize(new Dimension(50, 14));
        this.jLabel2.setMinimumSize(new Dimension(50, 14));
        this.cmbMethods.setFont(new Font("Tahoma", 0, 10));
        this.cmbMethods.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cmbMethods.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HttpView.this.cmbMethodsActionPerformed(evt);
            }
        });
        this.jLabel3.setFont(new Font("Tahoma", 1, 11));
        this.jLabel3.setText("HTTP Version:");
        this.btngrpHttp.add(this.rdbHttp10);
        this.rdbHttp10.setText("1.0");
        this.rdbHttp10.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rdbHttp10.setMargin(new Insets(0, 0, 0, 0));
        this.rdbHttp10.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HttpView.this.rdbHttp10ActionPerformed(evt);
            }
        });
        this.btngrpHttp.add(this.rdbHttp11);
        this.rdbHttp11.setText("1.1");
        this.rdbHttp11.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rdbHttp11.setMargin(new Insets(0, 0, 0, 0));
        this.rdbHttp11.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HttpView.this.rdbHttp11ActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel2, -2, 58, -2).addPreferredGap(0).add((Component)this.cmbMethods, -2, 119, -2).add(18, 18, 18).add((Component)this.jLabel3).addPreferredGap(0).add((Component)this.rdbHttp10).addPreferredGap(0).add((Component)this.rdbHttp11).addContainerGap(155, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.rdbHttp10).add((Component)this.rdbHttp11).add((Component)this.jLabel2, -2, -1, -2).add((Component)this.cmbMethods, -2, 18, -2)));
        this.jLabel7.setFont(new Font("Tahoma", 1, 11));
        this.jLabel7.setText("Headers:");
        this.jLabel4.setFont(new Font("Tahoma", 1, 11));
        this.jLabel4.setHorizontalAlignment(2);
        this.jLabel4.setText("Name:");
        this.jLabel8.setFont(new Font("Tahoma", 1, 11));
        this.jLabel8.setHorizontalAlignment(2);
        this.jLabel8.setText("Value:");
        this.cmbUrl.setEditable(true);
        this.cmbUrl.setMaximumSize(new Dimension(Short.MAX_VALUE, 20));
        this.cmbUrl.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                HttpView.this.cmbUrlItemStateChanged(evt);
            }
        });
        this.btnAddCustomHeader.setText("jButton1");
        this.btnAddCustomHeader.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HttpView.this.btnAddCustomHeaderActionPerformed(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout((Container)this.jPanel4);
        this.jPanel4.setLayout((LayoutManager)jPanel4Layout);
        jPanel4Layout.setHorizontalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().add((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel7, -2, 58, -2)).add(2, (GroupLayout.Group)jPanel4Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((Component)this.jLabel6, -2, 58, -2).add(2, (GroupLayout.Group)jPanel4Layout.createSequentialGroup().add((Component)this.jScrollPane1, -1, 437, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(2).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().add((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel4Layout.createSequentialGroup().add((Component)this.btnRemoveHeader).addPreferredGap(0).add((Component)this.btnUpdateHeader)).add(2, (GroupLayout.Group)jPanel4Layout.createSequentialGroup().add((GroupLayout.Group)jPanel4Layout.createParallelGroup(2).add(1, (GroupLayout.Group)jPanel4Layout.createSequentialGroup().add((Component)this.jLabel4, -2, 46, -2).addPreferredGap(0).add((Component)this.cmbHeaders, 0, 193, Short.MAX_VALUE)).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().add((Component)this.jLabel8, -2, 46, -2).addPreferredGap(0).add((Component)this.txtHeaderValue, -1, 193, Short.MAX_VALUE))).add(15, 15, 15).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(2, false).add((Component)this.btnAddCustomHeader, 0, 0, Short.MAX_VALUE).add((Component)this.btnShowHeaderHelper, -2, 30, Short.MAX_VALUE)))).addPreferredGap(0)).add((Component)this.btnAddHeader))).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().add((Component)this.jLabel1, -2, 58, -2).addPreferredGap(0).add((Component)this.cmbUrl, 0, 577, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.btnSend, -2, 92, -2)))).add((Component)this.jPanel2, -2, -1, -2)).addContainerGap()));
        jPanel4Layout.setVerticalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().add((Component)this.jLabel6).addPreferredGap(0).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.cmbUrl, -2, -1, -2).add((Component)this.btnSend)).addPreferredGap(0).add((Component)this.jPanel2, -2, -1, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jLabel7).addPreferredGap(0).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(1, false).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().add(5, 5, 5).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.btnAddCustomHeader).add((Component)this.cmbHeaders, -2, 18, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(3).add((Component)this.jLabel8).add((Component)this.btnShowHeaderHelper, -2, 23, -2).add((Component)this.txtHeaderValue, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(3).add((Component)this.btnRemoveHeader).add((Component)this.btnUpdateHeader)).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.btnAddHeader)).add((Component)this.jScrollPane1, -2, 117, -2)).addContainerGap()));
        this.lblStatus.setBorder(BorderFactory.createEtchedBorder());
        this.lblStatus.setFocusable(false);
        this.mnuFile.setText("File");
        this.mnuitemExit.setText("Exit");
        this.mnuitemExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HttpView.this.mnuitemExitActionPerformed(evt);
            }
        });
        this.mnuFile.add(this.mnuitemExit);
        this.mnubarMain.add(this.mnuFile);
        this.mnuEdit.setText("Edit");
        this.mnuitemProxy.setText("Proxy Settings...");
        this.mnuitemProxy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HttpView.this.mnuitemProxyActionPerformed(evt);
            }
        });
        this.mnuEdit.add(this.mnuitemProxy);
        this.mnuitemClearHistory.setText("Clear URL History");
        this.mnuitemClearHistory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HttpView.this.mnuitemClearHistoryActionPerformed(evt);
            }
        });
        this.mnuEdit.add(this.mnuitemClearHistory);
        this.mnubarMain.add(this.mnuEdit);
        this.mnuHelp.setText("Help");
        this.mnuitemAbout.setText("About");
        this.mnuitemAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HttpView.this.mnuitemAboutActionPerformed(evt);
            }
        });
        this.mnuHelp.add(this.mnuitemAbout);
        this.mnubarMain.add(this.mnuHelp);
        this.setJMenuBar(this.mnubarMain);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel4, -1, -1, Short.MAX_VALUE).add((Component)this.lblStatus, -1, 773, Short.MAX_VALUE).add((Component)this.jPanel5, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanel4, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel5, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.lblStatus, -2, 22, -2)));
        this.pack();
    }

    private void mnuitemClearHistoryActionPerformed(ActionEvent evt) {
        this.onClearHistoryClicked();
    }

    private void btnAddCustomHeaderActionPerformed(ActionEvent evt) {
        this.onAddCustomHeaderClick();
    }

    private void lstHeadersKeyReleased(KeyEvent evt) {
        this.onHeaderListKeyRelease(evt);
    }

    private void mnuitemAboutActionPerformed(ActionEvent evt) {
        this.onHelpAbout();
    }

    private void cmbUrlItemStateChanged(ItemEvent evt) {
        this.onRequestListChange();
    }

    private void btnShowHeaderHelperActionPerformed(ActionEvent evt) {
        this.onHeaderHelperButtonClick();
    }

    private void cmbHeadersActionPerformed(ActionEvent evt) {
        this.onHeaderListChange();
    }

    private void mnuitemProxyActionPerformed(ActionEvent evt) {
        new ProxySettings((Frame)this, true).setVisible(true);
    }

    private void formWindowClosing(WindowEvent evt) {
        this.doExit();
    }

    private void mnuitemExitActionPerformed(ActionEvent evt) {
        this.doExit();
    }

    private void lstHeadersValueChanged(ListSelectionEvent evt) {
        this.updateSelectedHeader();
    }

    private void rdbHttp11ActionPerformed(ActionEvent evt) {
    }

    private void rdbHttp10ActionPerformed(ActionEvent evt) {
    }

    private void cmbMethodsActionPerformed(ActionEvent evt) {
    }

    private void btnAddHeaderMouseReleased(MouseEvent evt) {
        if (this.getGuiState() == GuiState.IDLE) {
            this.addHeader();
        }
    }

    private void btnRemoveHeaderMouseReleased(MouseEvent evt) {
        if (this.getGuiState() == GuiState.IDLE) {
            this.removeHeader();
        }
    }

    private void btnUpdateHeaderMouseReleased(MouseEvent evt) {
        if (this.getGuiState() == GuiState.IDLE) {
            this.updateHeader();
        }
    }

    private void btnSendMouseClicked(MouseEvent evt) {
        this.onSendOrCancelClick();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum GuiState {
        IDLE,
        REQUEST_PENDING;

    }
}

