/*
 * Decompiled with CFR 0.152.
 */
package net.noip.codebox.httpbuilder.headerhelpers;

import java.util.LinkedHashMap;
import java.util.Map;
import net.noip.codebox.httpbuilder.headerhelpers.FieldBasedHeaderHelper;
import net.noip.codebox.httpbuilder.headerhelpers.panels.IPanel;
import net.noip.codebox.httpbuilder.headerhelpers.panels.ListPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarningHeaderHelper
extends FieldBasedHeaderHelper {
    private static final String WARNING = "Warning:";
    private static final String HOST = "Host:";

    @Override
    public String getTitle() {
        return "Warning Header Helper";
    }

    @Override
    protected void customInit() {
        ((ListPanel)this.fields.get(WARNING)).setData(new String[]{"110 - Response is stale", "111 - Revalidation failed", "112 - Disconnected operation", "113 - Heuristic expiration", "199 - Miscellaneous warning", "214 - Transformation applied", "299 - Miscellaneous persistent warning"});
    }

    @Override
    protected Map<String, FieldBasedHeaderHelper.FieldType> getFields() {
        LinkedHashMap<String, FieldBasedHeaderHelper.FieldType> fields = new LinkedHashMap<String, FieldBasedHeaderHelper.FieldType>();
        fields.put(WARNING, FieldBasedHeaderHelper.FieldType.LIST);
        fields.put(HOST, FieldBasedHeaderHelper.FieldType.UNRESTRICTED);
        return fields;
    }

    @Override
    protected String getCurrentValue() {
        String warningValue = ((IPanel)this.fields.get(WARNING)).getValue();
        String code = warningValue.split("-")[0].trim();
        String description = warningValue.split("-")[1].trim();
        return String.valueOf(code) + " " + ((IPanel)this.fields.get(HOST)).getValue() + " \"" + description + "\"";
    }
}

