/*
 * Decompiled with CFR 0.152.
 */
package net.noip.codebox.httpbuilder.headerhelpers.panels;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.noip.codebox.httpbuilder.headerhelpers.panels.IPanel;
import net.noip.codebox.httpbuilder.headerhelpers.panels.PanelChangeListener;

public class CheckboxPanel
implements IPanel {
    public static String SELECTED_VALUE = "true";
    public static String NOT_SELECTED_VALUE = "false";
    private static final Dimension LABEL_SIZE = new Dimension(100, 20);
    private static final Dimension BOX_SIZE = new Dimension(1000, 20);
    private JPanel panel;
    private JCheckBox checkBox;
    private JLabel label;
    private String name;

    public CheckboxPanel(String name) {
        this.name = name;
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 0));
        this.panel.add(Box.createHorizontalStrut(10));
        this.label = new JLabel(name);
        this.label.setPreferredSize(LABEL_SIZE);
        this.label.setMaximumSize(LABEL_SIZE);
        this.panel.add(this.label);
        this.checkBox = new JCheckBox("");
        this.panel.add(this.checkBox);
        this.checkBox.setMaximumSize(BOX_SIZE);
        this.panel.add(Box.createHorizontalStrut(10));
    }

    public String getName() {
        return this.name;
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public String getValue() {
        return this.checkBox.isSelected() ? SELECTED_VALUE : NOT_SELECTED_VALUE;
    }

    public void setValue(String value) {
        if (SELECTED_VALUE.equals(value)) {
            this.checkBox.setSelected(true);
        } else if (SELECTED_VALUE.equals(value)) {
            this.checkBox.setSelected(false);
        } else {
            throw new IllegalArgumentException("Bad value for checkbox - expected either '" + SELECTED_VALUE + "' or '" + NOT_SELECTED_VALUE + "'");
        }
    }

    public void addChangeListener(final PanelChangeListener listener) {
        this.checkBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                listener.onChange(CheckboxPanel.this);
            }
        });
    }

    public void setEnabled(boolean enabled) {
        this.checkBox.setEnabled(enabled);
    }

    public void setData(Object data) {
        throw new UnsupportedOperationException("not done");
    }
}

