/*
 * Decompiled with CFR 0.152.
 */
package net.noip.codebox.httpbuilder.headerhelpers.panels;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.noip.codebox.httpbuilder.headerhelpers.panels.IPanel;
import net.noip.codebox.httpbuilder.headerhelpers.panels.PanelChangeListener;

public class ListPanel
implements IPanel {
    private static final Dimension LABEL_SIZE = new Dimension(100, 20);
    private static final Dimension BOX_MAX_SIZE = new Dimension(1000, 20);
    private static final Dimension BOX_PREF_SIZE = new Dimension(100, 20);
    private String name;
    private JComboBox comboBox;
    private JPanel panel;
    private JLabel label;

    public ListPanel(String name) {
        this.name = name;
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 0));
        this.panel.add(Box.createHorizontalStrut(10));
        this.label = new JLabel(name);
        this.label.setPreferredSize(LABEL_SIZE);
        this.label.setMaximumSize(LABEL_SIZE);
        this.panel.add(this.label);
        this.comboBox = new JComboBox();
        this.comboBox.setMaximumSize(BOX_MAX_SIZE);
        this.comboBox.setPreferredSize(BOX_PREF_SIZE);
        this.panel.add(this.comboBox);
        this.panel.add(Box.createHorizontalStrut(10));
    }

    public void addChangeListener(final PanelChangeListener listener) {
        this.comboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                listener.onChange(ListPanel.this);
            }
        });
    }

    public String getName() {
        return this.name;
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public String getValue() {
        return this.comboBox.getSelectedItem().toString();
    }

    public void setEnabled(boolean enabled) {
        this.comboBox.setEnabled(enabled);
    }

    public void setValue(String value) {
        this.comboBox.setSelectedItem(value);
    }

    public void setData(Object data) {
        this.comboBox.setModel(new DefaultComboBoxModel<String>((String[])data));
    }
}

