/*
 * Decompiled with CFR 0.152.
 */
package net.noip.codebox.httpbuilder.util;

import net.noip.codebox.httpbuilder.util.Config;
import net.noip.codebox.httpbuilder.util.ConfigException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConfigTest {
    private static final String KEY_STR1 = "test.string1";
    private static final String KEY_STR2 = "test.string2";
    private static final String KEY_INT = "test.int";
    private static final String KEY_BOOL = "test.bool";

    @Before
    @After
    public void removeTestValues() throws ConfigException {
        Config.removeKey(KEY_STR1);
        Config.removeKey(KEY_STR2);
        Config.removeKey(KEY_INT);
        Config.removeKey(KEY_BOOL);
    }

    @Test
    public void testStrings() throws ConfigException {
        String VALUE_1 = "string1";
        Config.setStringValue(KEY_STR1, "string1");
        Assert.assertEquals((Object)"string1", (Object)Config.getStringValue(KEY_STR1));
        String VALUE_2 = "string2";
        Config.setStringValue(KEY_STR2, "string2");
        Assert.assertEquals((Object)"string2", (Object)Config.getStringValue(KEY_STR2));
        Assert.assertEquals((Object)"string1", (Object)Config.getStringValue(KEY_STR1));
    }

    @Test
    public void testInts() throws ConfigException {
        int VALUE_1 = 100;
        int VALUE_2 = 200;
        Config.setIntValue(KEY_INT, 100);
        Assert.assertEquals((Object)100, (Object)Config.getIntValue(KEY_INT));
        Config.setIntValue(KEY_INT, 200);
        Assert.assertEquals((Object)200, (Object)Config.getIntValue(KEY_INT));
        Config.setStringValue(KEY_INT, "not a number");
        try {
            Config.getIntValue(KEY_INT);
            Assert.fail((String)"Expected NumberFormatException");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Test
    public void testBooleans() throws ConfigException {
        Config.setBooleanValue(KEY_BOOL, true);
        Assert.assertTrue((boolean)Config.getBooleanValue(KEY_BOOL));
        Config.setBooleanValue(KEY_BOOL, false);
        Assert.assertFalse((boolean)Config.getBooleanValue(KEY_BOOL));
        Config.setStringValue(KEY_BOOL, "not a boolean");
        try {
            Config.getBooleanValue(KEY_BOOL);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testHasKeyRemoveKey() throws ConfigException {
        Config.removeKey(KEY_STR1);
        Assert.assertEquals((Object)false, (Object)Config.hasKey(KEY_STR1));
        Config.removeKey(KEY_STR1);
        Assert.assertEquals((Object)false, (Object)Config.hasKey(KEY_STR1));
        Config.setStringValue(KEY_STR1, "something");
        Assert.assertEquals((Object)true, (Object)Config.hasKey(KEY_STR1));
        Config.setStringValue(KEY_STR1, "something");
        Assert.assertEquals((Object)true, (Object)Config.hasKey(KEY_STR1));
        Config.removeKey(KEY_STR1);
        Assert.assertEquals((Object)false, (Object)Config.hasKey(KEY_STR1));
    }
}

