/*
 * Decompiled with CFR 0.152.
 */
package net.noip.codebox.httpbuilder.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import net.noip.codebox.httpbuilder.util.Config;
import net.noip.codebox.httpbuilder.util.ConfigException;

class PropertiesFileData {
    private Properties propertiesFile = new Properties();
    private File file;

    PropertiesFileData(String fileName) throws ConfigException {
        try {
            FileInputStream is = null;
            this.file = new File(Config.getApplicationDir(), fileName);
            if (!this.file.exists()) {
                InputStream stream = PropertiesFileData.class.getResourceAsStream("/httpbuilder.default.properties");
                FileOutputStream output = new FileOutputStream(this.file);
                byte[] b = new byte[1000];
                int v = 0;
                while ((v = stream.read(b)) > -1) {
                    output.write(b, 0, v);
                }
                stream.close();
                output.flush();
                output.close();
            }
            is = new FileInputStream(this.file);
            this.propertiesFile.load(is);
        }
        catch (FileNotFoundException ex) {
            throw new ConfigException("Can't find config file " + fileName, ex);
        }
        catch (IOException ex) {
            throw new ConfigException("I/O exception accessing config file " + fileName, ex);
        }
    }

    void save() throws ConfigException {
        try {
            this.propertiesFile.store(new FileOutputStream(this.file), null);
        }
        catch (FileNotFoundException e) {
            throw new ConfigException("Could not find the config file '" + this.file.getAbsolutePath() + "'", e);
        }
        catch (IOException e) {
            throw new ConfigException("Unable to write to the config file '" + this.file.getAbsolutePath() + "'", e);
        }
    }

    synchronized String getValue(String key) {
        return this.propertiesFile.getProperty(key);
    }

    synchronized void setValue(String key, String newValue) throws ConfigException {
        String currentValue;
        if (newValue != null && !newValue.equals(currentValue = this.propertiesFile.getProperty(key))) {
            this.propertiesFile.setProperty(key, newValue);
            this.save();
        }
    }

    synchronized boolean hasValue(String key) {
        return this.propertiesFile.containsKey(key);
    }

    synchronized String removeValue(String key) throws ConfigException {
        String removedValue = (String)this.propertiesFile.remove(key);
        this.save();
        return removedValue;
    }
}

