/*
 * Decompiled with CFR 0.152.
 */
package net.noip.codebox.logmonitor.target;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.noip.codebox.logmonitor.target.AbstractMonitor;
import net.noip.codebox.logmonitor.target.TargetAccessException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileMonitor
extends AbstractMonitor {
    private static final Logger logger = Logger.getLogger("net.noip.codebox.logmonitor.target.FileMonitor");
    private static final String EOL = System.getProperty("line.separator");
    private static final int CHUNK_SIZE = 100;
    private Map<String, Integer> dateMarkers;
    private boolean dynamicFileName;
    private final String filePath;

    public FileMonitor(String string, String string2) {
        this.filePath = string2;
        this.name = string;
        this.setupDateMarkersMap();
        this.dynamicFileName = this.containsDynamicMarkers(string2);
    }

    public String getDescription() {
        return "File " + this.filePath;
    }

    private File getFile() {
        return new File(this.getFileName());
    }

    private String getFileName() {
        if (this.dynamicFileName) {
            return this.processFilePath(this.filePath);
        }
        return this.filePath;
    }

    private void setupDateMarkersMap() {
        this.dateMarkers = new HashMap();
        this.dateMarkers.put("%y%", 1);
        this.dateMarkers.put("%M%", 2);
        this.dateMarkers.put("%d%", 5);
        this.dateMarkers.put("%H%", 11);
        this.dateMarkers.put("%m%", 12);
        this.dateMarkers.put("%s%", 13);
    }

    private String processFilePath(String string) {
        String string2 = string;
        Calendar calendar = Calendar.getInstance();
        for (String string3 : this.dateMarkers.keySet()) {
            if (!string.contains(string3)) continue;
            int n = (Integer)this.dateMarkers.get(string3);
            int n2 = calendar.get(n);
            if (n == 2) {
                ++n2;
            }
            String string4 = n2 < 10 ? "0" + n2 : "" + n2;
            string2 = string2.replace(string3, string4);
        }
        return string2;
    }

    private boolean containsDynamicMarkers(String string) {
        boolean bl = false;
        for (String string2 : this.dateMarkers.keySet()) {
            if (!string.contains(string2)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public List<List<String>> getLatestEntries(int n) throws TargetAccessException {
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
        AbstractInterruptibleChannel abstractInterruptibleChannel = null;
        FileLock fileLock = null;
        try {
            if (!this.verify()) {
                throw new IOException("Unable to verify file '" + this.getFileName() + "'");
            }
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.getFile(), "rw");
            abstractInterruptibleChannel = randomAccessFile.getChannel();
            fileLock = ((FileChannel)abstractInterruptibleChannel).lock();
            byte[] byArray = new byte[100];
            String string = "";
            long l = randomAccessFile.length() - 100L;
            if (l < 0L) {
                l = 0L;
            }
            randomAccessFile.seek(l);
            int n2 = (int)randomAccessFile.length();
            int n3 = l + 100L > (long)n2 ? n2 : 100;
            while (true) {
                ArrayList<String> arrayList2;
                int n4;
                int n5 = n4 = (int)randomAccessFile.getFilePointer();
                int n6 = randomAccessFile.read(byArray, 0, n3);
                if (n6 <= 0) {
                    break;
                }
                String string2 = new String(byArray).substring(0, n6);
                string2 = string2 + string;
                String[] stringArray = string2.split(EOL);
                string = stringArray[0];
                if (string2.startsWith(EOL)) {
                    assert (string.length() == 0) : "Expected empty 'leftOvers' variable";
                    string = EOL + string;
                }
                for (int i = stringArray.length - 1; i > 0; --i) {
                    arrayList2 = new ArrayList<String>();
                    arrayList2.add(stringArray[i]);
                    if (!this.includeEntry(arrayList2)) continue;
                    arrayList.add(0, arrayList2);
                }
                if (arrayList.size() >= n) {
                    break;
                }
                if (n5 == 0) {
                    if (string.length() > 0 && arrayList.size() < n) {
                        arrayList2 = new ArrayList();
                        arrayList2.add(string);
                        if (this.includeEntry(arrayList2)) {
                            arrayList.add(0, arrayList2);
                        }
                    }
                    break;
                }
                if (n5 < 100) {
                    randomAccessFile.seek(0L);
                    n3 = n5;
                    continue;
                }
                randomAccessFile.seek(n5 - 100);
                n3 = 100;
            }
        }
        catch (IOException iOException) {
            throw new TargetAccessException(this.getName(), "IOException while trying to access the file '" + this.getFileName() + "'", (Throwable)iOException);
        }
        finally {
            if (fileLock != null) {
                try {
                    fileLock.release();
                }
                catch (IOException iOException) {
                    logger.warning("Unable to close file " + this.filePath);
                }
            }
            if (abstractInterruptibleChannel != null) {
                try {
                    abstractInterruptibleChannel.close();
                }
                catch (Exception exception) {
                    logger.warning("Unable to close file " + this.filePath);
                }
            }
        }
        return arrayList;
    }

    public long lastUpdateTime() throws TargetAccessException {
        long l = this.getFile().lastModified();
        if (l > 0L) {
            return l;
        }
        throw new TargetAccessException(this.getName(), "Unable to access the file target '" + this.getFileName() + "'");
    }

    public boolean verify() {
        return this.getFile().exists();
    }
}

