/*
 * Decompiled with CFR 0.152.
 */
package net.noip.codebox.logmonitor.target;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.noip.codebox.logmonitor.target.AbstractMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestFileMonitor
extends AbstractMonitor {
    private final String name;
    private static final DateFormat LOG_DATE_FORMAT = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss Z");
    private static final int[] UPDATES = new int[]{1, 0, 0, 3, 0, 1, 1, 2};
    private static final int BAIL_OUT_VALUE = 1000;
    private static final String[] HOSTS = new String[]{"192.168.0.1", "192.168.0.2", "192.168.0.3", "192.168.0.4", "192.168.0.5"};
    private static final String[] IDENTS = new String[]{"-"};
    private static final String[] USERIDS = new String[]{"-"};
    private static final String[] REQUESTS = new String[]{"GET /index.html HTTP/1.0", "GET /testpage1.html HTTP/1.0", "GET /graphics/fasteddie.jpg HTTP/1.0", "GET favicon.ico HTTP/1.1", "POST /cgi-bin/login.php HTTP/1.1"};
    private static final String[] CODES = new String[]{"200", "200", "200", "302", "304", "200", "200", "404", "200"};
    private static final String[] SIZES = new String[]{"1234", "2000", "1024", "32000", "32"};
    private static final String[] REFERERS = new String[]{"http://www.google.com", "-", "-", "http://slashdot.org", "-", "http://whitehouse.gov", "http://codebox.no-ip.net", "-", "-"};
    private static final String[] AGENTS = new String[]{"Mozilla/4.08 [en] (Win98; I ;Nav)", "-", "-", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1; .NET CLR 2.0.50727; .NET CLR 1.1.4322)", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1", "Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1) Gecko/20060601 Firefox/2.0 (Ubuntu-edgy)", "Speedy Spider (Entireweb; Beta/1.0; http://www.entireweb.com/about/search_tech/speedyspider/)", "-", "-"};

    public TestFileMonitor(String string, String string2) {
        this.name = string;
    }

    public String getDescription() {
        return "Test " + this.name;
    }

    public List<List<String>> getLatestEntries(int n) {
        int n2;
        int n3 = 0;
        long l = new Date().getTime();
        long l2 = l / 1000L;
        int n4 = n2 = (int)(l2 % (long)UPDATES.length);
        int n5 = 0;
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
        long l3 = l2;
        while (n3 < n) {
            int n6 = UPDATES[n4];
            if (n6 > 0) {
                for (int i = 0; i < n6; ++i) {
                    String string = this.makeDateStringFromTS(l3 * 1000L);
                    List list = this.buildLogEntry(l3 + (long)i, string);
                    if (!this.includeEntry(list)) continue;
                    arrayList.add(list);
                    ++n3;
                }
            }
            if (--n4 < 0) {
                n4 += UPDATES.length;
            }
            if (++n5 > 1000) break;
            --l3;
        }
        return arrayList;
    }

    public long lastUpdateTime() {
        long l = new Date().getTime();
        long l2 = l / 1000L;
        int n = (int)(l2 % (long)UPDATES.length);
        long l3 = 0L;
        int n2 = UPDATES.length;
        for (int i = 0; i < n2; ++i) {
            int n3 = n - i;
            if (n3 < 0) {
                n3 += UPDATES.length;
            }
            if (UPDATES[n3] <= 0) continue;
            l3 = l2 - (long)i;
            break;
        }
        return l3 * 1000L;
    }

    public boolean verify() {
        return true;
    }

    private List<String> buildLogEntry(long l, String string) {
        assert (l > 0L);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(HOSTS[(int)(l % (long)HOSTS.length)] + " ");
        arrayList.add(IDENTS[(int)(l % (long)IDENTS.length)] + " ");
        arrayList.add(USERIDS[(int)(l % (long)USERIDS.length)] + " ");
        arrayList.add(string + " ");
        arrayList.add(REQUESTS[(int)(l % (long)REQUESTS.length)] + " ");
        arrayList.add(CODES[(int)(l % (long)CODES.length)] + " ");
        arrayList.add(SIZES[(int)(l % (long)SIZES.length)] + " ");
        arrayList.add(REFERERS[(int)(l % (long)REFERERS.length)] + " ");
        arrayList.add(AGENTS[(int)(l % (long)AGENTS.length)] + " ");
        return arrayList;
    }

    private String makeDateStringFromTS(long l) {
        Date date = new Date(l);
        return "[" + LOG_DATE_FORMAT.format(date) + "]";
    }
}

